@extends('adminlayout.dashadmin')

@section('content')
<div class="content-wrapper">
<section class="content">
 <div class="row profile-heading">

      <div class="col-sm-12 col-xs-12 contact">
        <div class="box box-info">
          <div class="box-header with-border text-center">
            <h3 class="box-title">Transfer Lead</h3>
                <a class="btn btn-sm btn-dark" href="javascript:history.back()" style="float: inline-end;"> << Go Back</a>
          </div>
          
        @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif

           
                        
						<div class="modal-body">
                            <div class="row">
                                
                               
                                <div class="col-sm-4 ">               
                                <label for="date" class="control-label">
                                  <b> Transfer From <i class="required">*</i></b>
                                </label>
                               <!-- FROM Employee (assignedToSelect) -->
                                <select id="assignedToSelect" class="form-control" name="transfer_f" onchange="updateNewAssignedTo()" required>
                                    <option value="">--Select--</option>
                                    @foreach($employees as $tranf)
                                        <option value="{{ $tranf->id }}">{{ $tranf->name }}</option>
                                    @endforeach  
                                </select>  
                              </div>
                              
                               <div class="col-sm-4 "> 
                              <label for="statusSelect">Filter by Status:</label>
                                <select id="statusSelect" multiple>
                                    <option value="New">New</option>
                                    <option value="Interested">Interested</option>
                                    <option value="NotInterested">Not Interested</option>
                                    <option value="Callback Later">Callback Later</option>
                                    <option value="Converted">Converted</option>
                                    <option value="Dropped">Dropped</option>
                                </select>
                                
                              </div>
                              <div class="col-sm-4 mt-5">
                                <button class="btn btn-info btn-sm" id="filterBtn"> <i class="fa fa-search"></i>Filter</button>
                                </div>
                              <div class="col-sm-12">
                                  <!-- Display Filtered Leads -->
                                    <div id="leadResults"></div>

                              </div>
                            


                              <div class="col-sm-4 ">               
                                <label for="date" class="control-label">
                                  <b> Transfer Selected Leads<i class="required">*</i></b>
                                </label>
                               <!-- TO Employee (newAssignedTo) -->
                                <select id="newAssignedTo" class="form-control" name="transfer_to" required>
                                    <option value="">--Select--</option>
                                    @foreach($employees as $emp)
                                        <option value="{{ $emp->id }}">{{ $emp->name }}</option>
                                    @endforeach  
                                </select>
                              </div>
                             
                            </div>
                            

                            </div>
							<div class="modal-footer" style="text-align: center;">
							 
							  <button id="transferBtn" class="btn btn-lg btn-info" name="submit" data-loading-text="Processing...">
								<i class="fa fa-fw fa-save"></i>
								  Submit        </button>
							</div>
                        
                    </div>
                </div>
            </div>       
   </section>
</div>

<!-- jQuery Script -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $('#filterBtn').on('click', function () {
        let assignedTo = $('#assignedToSelect').val();
        let status = $('#statusSelect').val(); // Multiple select

        $.ajax({
            url: '{{ route("leads.get") }}',
            method: 'GET',
            data: {
                assigned_to: assignedTo,
                status: status
            },
            success: function (data) {
                $('#leadResults').empty();
                if (data.length === 0) {
                    $('#leadResults').append('<p style="color: red;padding: 10px;border: 1px solid red;" >No leads found.</p>');
                } else {
                    let table = '<div class="table-responsive"> <table class="table table-bordered table-striped table-hover dataTable" ><tr><th>Select</th><th>ID</th><th>Name</th><th>Email</th><th>Status</th></tr>';
                    data.forEach(lead => {
                        table += `<tr>
                            <td><input type="checkbox" class="lead-checkbox" value="${lead.id}"></td>
                            <td>${lead.id}</td>
                            <td>${lead.name}</td>
                            <td>${lead.email}</td>
                            <td>${lead.status}</td>
                        </tr>`;
                    });
                    table += '</table></div>';
                    $('#leadResults').append(table);
                }
            }
        });
    });

    $('#transferBtn').on('click', function () {
        let selectedLeads = [];
        $('.lead-checkbox:checked').each(function () {
            selectedLeads.push($(this).val());
        });

        let newAssignedTo = $('#newAssignedTo').val();

        if (selectedLeads.length === 0 || !newAssignedTo) {
            alert('Please select leads and a user to transfer to.');
            return;
        }

        $.ajax({
            url: '{{ route("leads.transfer") }}',
            method: 'POST',
            data: {
                lead_ids: selectedLeads,
                new_assigned_to: newAssignedTo,
                _token: $('meta[name="csrf-token"]').attr('content')
            },
            success: function (res) {
                alert(res.message);
                $('#filterBtn').click(); // refresh table
            }
        });
    });
</script>
<script>
    function updateNewAssignedTo() {
        let selectedFromId = document.getElementById('assignedToSelect').value;
        let newAssignedTo = document.getElementById('newAssignedTo');

        // Get all options
        for (let i = 0; i < newAssignedTo.options.length; i++) {
            let option = newAssignedTo.options[i];
            if (option.value === selectedFromId && option.value !== "") {
                option.style.display = 'none'; // Hide if same as "from"
            } else {
                option.style.display = ''; // Show otherwise
            }
        }

        // Reset newAssignedTo if same as selectedFrom
        if (newAssignedTo.value === selectedFromId) {
            newAssignedTo.value = '';
        }
    }
</script>


@endsection