@extends('adminlayout.dashadmin')

@section('content')
<div class="content-wrapper">
<section class="content">
 <div class="row profile-heading">

      <div class="col-sm-12 col-xs-12 contact">
        <div class="box box-info">
          <div class="box-header with-border text-center">
            <h3 class="box-title">Call Back Leads </h3>
                <a class="btn btn-sm btn-dark" href="javascript:history.back()" style="float: inline-end;"> << Go Back</a>
          </div>
          
        @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif

           
                        
						<div class="modal-body">
						    <div class="table-responsive"> 
			 <div id="supplier-supplier-list_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
                    <table id="example1" class="table table-bordered table-striped table-responsive">
                        <thead>
                            <tr>
                                <th>S.no</th>
                                <th>Name</th>
                                <th>Phone No.</th>
                                <th>City</th>
                                <th>State</th>
                                <th>Interest In</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                       
                        <tbody>
                         @foreach ($converted_leads as $index => $lead)
                        <tr id="199">
                        <td>{{ $index + 1 }}</td>
                        <td>{{ $lead->name }}</td>

                       
                       
                        
    
                        <td>{{ $lead->phone }}</td>
                        @php
                        $state = DB::table('states')
                                    ->where('id', $lead->state)
                                    ->select('name')
                                    ->first();
                                    
                         $city = DB::table('cities')
                                    ->where('id', $lead->city)
                                    ->select('name')
                                    ->first(); 
                        @endphp

                       

                       
                        
                        @if($city)
                            <td>{{$city->name}}</td>
                        @else
                            <td>-</td>
                        @endif
                        
                         @if($state)
                            <td>{{ $state->name }}</td>
                        @else
                            <td>-</td>
                        @endif
                        
                        <td>{{$lead->product_interest}}</td>
                        <td>
                        <!-- Trigger Button -->
                        <button type="button" class="btn btn-sm btn-info" data-toggle="modal" data-target="#followupModal-{{ $lead->id }}">
                        View Followup
                        </button>
                        <button type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#addfollowup-{{ $lead->id }}">
                        Add Followup
                        </button>
                        
                        <!-- Modal -->
                        <div class="modal fade" id="followupModal-{{ $lead->id }}" tabindex="{{ $lead->id }}" role="dialog" aria-labelledby="followupLabel-{{ $lead->id }}" aria-hidden="true" style="display: none;">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                        
                                <div class="modal-header">
                                    <h5 class="modal-title" style="text-align: center!important;" id="followupLabel-{{ $lead->id }}">
                                        Followup Details for {{ $lead->name }}
                                    </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">×</span>
                                    </button>
                                </div>
                        
                                <div class="modal-body">
                                    <div class="row">
                                        <div class="col-sm-12 col-md-12">
                                            
                                                <table class="table bordered">
                                                   <tr>
                                                   <th>Follow sn</th>
                                                   <th>FollowUp Date</th>
                                                   <th>Next FollowUp Date</th>
                                                   <th>Notes</th>
                                                   <th>Track On Maps</th>
                                                   </tr>
                                                   @forelse ($lead->followups as $followup)
                                                   <tr>
                                                       <td>{{$loop->iteration}}</td>
                                                       <td>{{ $followup->created_at->format('d M Y ') }}</td>
                                                       <td>@if ($followup->next_followup_date)
                                                                    {{ \Carbon\Carbon::parse($followup->next_followup_date)->format('d M Y') }}
                                                                @else
                                                        <span class="text-muted">-</span>
                                                                @endif
                                                       </td>
                                                       <td>{{ $followup->notes }}</td>
                                                          <td><a href="https://www.google.com/maps?q={{ $followup->latitude }},{{ $followup->longitude }}" target="_blank">
        View on Google Maps
    </a></td>
                                                       @empty
                                                <td>No followup records found.</td>
                                            @endforelse
                                                   </tr>
                                                   
                                               </table>
                                                
                                            
                                        </div>
                                    </div>
                                </div>
                        
                                <div class="modal-footer" style="text-align: center;">
                                    <a href="#" data-dismiss="modal" class="btn btn-secondary">Close</a>
                                </div>
                        
                            </div>
                        </div>
                        <br>
                        </div>
                        
                        
                        
                        <!--add follow up model start-->
                        <!-- Modal -->
                        <div class="modal fade" id="addfollowup-{{ $lead->id }}" tabindex="{{ $lead->id }}" role="dialog" aria-labelledby="followupLabel-{{ $lead->id }}" aria-hidden="true" style="display: none;">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                        
                                <div class="modal-header">
                                    <h5 class="modal-title" style="text-align: center!important;" id="followupLabel-{{ $lead->id }}">
                                        New Followup {{ $lead->name }}
                                    </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">×</span>
                                    </button>
                                </div>
                        
                                <div class="modal-body">
                                    <div class="row">
                                        <div class="col-sm-12 col-md-12">
                                            <form method="post" class="form-horizontal" action="{{ route('update_lead') }}" enctype="multipart/form-data">
                            @csrf
                                          <div class="row">
<hr>
<h3 class="box-title text-center"> Lead Followups  </h3>                                              
       
      
    
     <div class="col-sm-4">
        <label for="Remarks" class="control-label">Followup Date </label>
        <input type="hidden" name="id" value="{{ $lead->id }}">
        <input type="hidden" name="latitude" id="latitude" value="">
         <input type="hidden" name="longitude" id="longitude" value="">
        <input type="date" name="followup" class="form-control" required="">
    </div>
    <div class="col-sm-4">
        <label for="Remarks" class="control-label">Next Followup(optional) </label>
         <input type="date" name="nextfollowup" class="form-control">
    </div>
    <div class="col-sm-4">
        <label for="Status" class="control-label">Followup Status </label>
        <select class="form-control"  name="status" required="">
                <option>--Select--</option>
                <option value="New">New</option>
                <option value="Interested">Interested</option>
                <option value="NotInterested">Not Interested</option>
                <option value="CallbackLater">Callback Later</option>
                <option value="Converted">Converted</option>
                <option value="Dropped">Dropped</option>
            </select>
    </div>
    <div class="col-sm-4">
        <label for="call status" class="control-label">Call Status </label>
        <select class="form-control" name="call_status" required="">
            <option value="">-- Select Call Status --</option>
          <option value="Connected">Connected</option>
          <option value="Not Reachable">Not Reachable</option>
          <option value="Busy">Busy</option>
          <option value="No Answer">No Answer</option>
          <option value="Switched Off">Switched Off</option>
          <option value="Invalid Number">Invalid Number</option>
      </select>
        
    </div>
     
                                          </div>
                                          
<div class="row">
    <hr>
    <div class="col-sm-12">
         <label for="Remarks" class="control-label">Remarks</label>
            <textarea name="notes" placeholder="Enter Remark" class="form-control" required="" style=" width: 100%;" ></textarea>
            <span class="text-danger"></span>
       
    </div>
    <hr>
    <div class="col-sm-12 text-center mt-5">
          <button type="submit" class="btn btn-lg btn-primary">Update</button>
       
    </div>
</div>                                          
                                        </div>
                                        </form>
                                    </div>
                                </div>
                        
                                <div class="modal-footer" style="text-align: center;">
                                    
                                </div>
                        
                            </div>
                        </div>
                        <br>
                        </div>
                        
                        
                        
                        
                        </td>
                        
                        </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
                          </div>
                    </div>
                </div>
            </div>       
   </section>
</div>
<script type="text/javascript">

  function partyHandler(val='')
  {
    var party_name = $('#party_name').val();
    var supply_state = $('#supply_state').val();
    var city = $('#city').val();
    
    //$('#reset').click();
    //$('#total').html('0');
    $('#party_name').val(party_name);
    $('#supply_state').val(supply_state);
    $('#city').val(city);
    
    if(val)
    {
      $("#vehiclelist :input").attr("disabled", false);
    }else{
      $("#vehiclelist :input").attr("disabled", true);

    }
  }
  partyHandler();
</script>  
<script >
  function getCity(state_id)
  {
   $.ajax({
    type: "GET",
    url: "{{url('city-list')}}/" + state_id,
    dataType: 'json',
    success: function(response) {
      console.log(response.cities);
      var option = '';
      if (response.status) {
       option += '<option value="" selected disabled> -- Select Option -- </option>';
       for (let index = 0; index < response.cities.length; index++) {
        option += "<option value='" + response.cities[index].id + "'>" + response.cities[index].name + "</option>";
      }
      $('#city').html(option);
    } else {
      $('#city').html(option);
    }
  }
});
 }
 </script>
  <style>
  /* Simple modal styles */
  #locationModal {
    display: none; /* Hidden by default */
    position: fixed;
    z-index: 10000; /* on top */
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    overflow: auto;
    background-color: rgba(0,0,0,0.5); /* Black with opacity */
  }
  #locationModalContent {
    background-color: #fff;
    margin: 15% auto; /* Centered */
    padding: 20px;
    border-radius: 8px;
    width: 300px;
    text-align: center;
  }
  #locationModal button {
    background-color: #007bff;
    color: white;
    border: none;
    padding: 10px 20px;
    border-radius: 5px;
    cursor: pointer;
  }
  #locationModal button:hover {
    background-color: #0056b3;
  }
</style>

<!-- Modal HTML -->
<div id="locationModal">
  <div id="locationModalContent">
    <p>Location permission is required to proceed.</p>
    <button id="retryLocationBtn">Enable Location</button>
  </div>
</div>

<script>
  document.addEventListener('DOMContentLoaded', function () {
      getLocation();

      const forms = document.querySelectorAll('form');
      forms.forEach(function(form) {
          form.addEventListener('submit', function(e) {
              const lat = document.getElementById('latitude').value;
              const lng = document.getElementById('longitude').value;

              if (!lat || !lng) {
                  e.preventDefault();
                  alert('Please enable location to proceed.');
              }
          });
      });

      // Retry button inside modal
      document.getElementById('retryLocationBtn').addEventListener('click', function() {
          hideModal();
          getLocation();
      });
  });

  function getLocation() {
      if (navigator.geolocation) {
          navigator.geolocation.getCurrentPosition(
              showPosition,
              showError,
              {
                  enableHighAccuracy: true,
                  timeout: 10000,
                  maximumAge: 0
              }
          );
      } else {
          alert("Geolocation is not supported by this browser.");
      }
  }

  function showPosition(position) {
      document.querySelectorAll('#latitude').forEach(input => {
          input.value = position.coords.latitude;
      });
      document.querySelectorAll('#longitude').forEach(input => {
          input.value = position.coords.longitude;
      });
      locationCaptured = true;
      hideModal();
  }

  function showError(error) {
      switch (error.code) {
          case error.PERMISSION_DENIED:
              // Show modal instead of alert
              showModal();
              break;
          case error.POSITION_UNAVAILABLE:
              alert("Location information is unavailable.");
              break;
          case error.TIMEOUT:
              alert("The request to get your location timed out.");
              break;
          case error.UNKNOWN_ERROR:
              alert("An unknown error occurred while fetching your location.");
              break;
      }
  }

  function showModal() {
      document.getElementById('locationModal').style.display = 'block';
  }
  function hideModal() {
      document.getElementById('locationModal').style.display = 'none';
  }
</script>
@endsection